SOUNDS_CONFIG = {
    soundChannel = SoundChannels.Music,
    checkInterval = 500,
    folder = 'music/',
}

local PLAYLIST1 = {
    {file = "PLAYLIST1_1.ogg", duration = 37}, -- 00:37 Track 1 - Kingdoms & Lords by Gameloft
    {file = "PLAYLIST1_2.ogg", duration = 35}, -- 00:35 Track 2 - Kingdoms & Lords by Gameloft
    {file = "PLAYLIST1_3.ogg", duration = 35}, -- 00:35 Track 3 - Kingdoms & Lords by Gameloft
    {file = "PLAYLIST1_4.ogg", duration = 26}, -- 00:26 Track 4 - Kingdoms & Lords by Gameloft
    {file = "PLAYLIST1_5.ogg", duration = 30}, -- 00:30 Track 5 - Kingdoms & Lords by Gameloft
    {file = "PLAYLIST1_6.ogg", duration = 39}, -- 00:39 Track 6 - Kingdoms & Lords by Gameloft
    {file = "PLAYLIST1_7.ogg", duration = 54}, -- 00:54 Track 7 - Kingdoms & Lords by Gameloft
    {file = "PLAYLIST1_8.ogg", duration = 239}, -- 03:59 The Shire - J.R.R. Tolkien's Lord of the Rings, Vol. I by Interplay
    {file = "PLAYLIST1_9.ogg", duration = 147}, -- 02:27 Title - J.R.R. Tolkien's Lord of the Rings, Vol. I by Interplay
    {file = "PLAYLIST1_10.ogg", duration = 206}, -- 03:26 On our war - Final Fantasy VII by Squaresoft
    {file = "PLAYLIST1_11.ogg", duration = 259} -- 04:19 Corssing Those Hills - Final Fantasy IX by Squaresoft
}

local PLAYLIST2 = {
    {file = "PLAYLIST2_1.ogg", duration = 130}, -- 02:10 Dark World - The Legend of Zelda A link to the past by Nintendo
    {file = "PLAYLIST2_2.ogg", duration = 96},  -- 01:36 Dark Dungeon - The Legend of Zelda A link to the past by Nintendo
    {file = "PLAYLIST2_3.ogg", duration = 106}, -- 01:46 Death Mountain - The Legend of Zelda A link to the past by Nintendo
    {file = "PLAYLIST2_4.ogg", duration = 86},  -- 01:26 Desolate Field - J.R.R. Tolkien's Lord of the Rings, Vol. I by Interplay
    {file = "PLAYLIST2_5.ogg", duration = 114}, -- 01:54 Mines of Moria - J.R.R. Tolkien's Lord of the Rings, Vol. I by Interplay
    {file = "PLAYLIST2_6.ogg", duration = 139}, -- 02:19 Beyond the Colosseum - Demon's Crest by Capcom
    {file = "PLAYLIST2_7.ogg", duration = 76}, -- 01:16 Cerberus - Castlevania Dracula X by Konami
    {file = "PLAYLIST2_8.ogg", duration = 72}, -- 01:12 Titile - Final Fantasy VI by Squaresoft
    {file = "PLAYLIST2_9.ogg", duration = 303}, -- 05:03 The Castle - Final Fantasy VIII by Squaresoft
    {file = "PLAYLIST2_10.ogg", duration = 302} -- 05:02 Finale Toccata - Final Fantasy VIII by Squaresoft
}

local PLAYLIST3 = {
    {file = "PLAYLIST3_1.ogg", duration = 231} -- 03:51 Anxious Heart - Final Fantasy VII by Squaresoft
}

local PLAYLIST4 = {
    {file = "PLAYLIST4_1.ogg", duration = 294} -- 04:54 Flowers Blooming in the Church - Final Fantasy VII by Squaresoft
}

local PLAYLIST5 = {
    {file = "PLAYLIST5_1.ogg", duration = 188} -- 04:54 Guardia Millennial Fair - Chrono Trigger by Squaresoft
}

local PLAYLIST6 = {
    {file = "PLAYLIST6_1.ogg", duration = 98} -- 01:38 Paceful Space - E. V. O. Search for Eden by Enix
}

local PLAYLIST7 = {
    {file = "PLAYLIST7_1.ogg", duration = 297}, -- 04:57 Opus 13 Remix - Konami's Castlevania Dracula X by 8-Beats VGM
    {file = "PLAYLIST7_2.ogg", duration = 317} -- 05:17 Vampire Killer Remix - Konami's Castlevania IV Patricio Herrera
}

local PLAYLIST8 = {
    {file = "PLAYLIST8_1.ogg", duration = 221} -- 03:41 Hunter's Chance - Final Fantasy IX by Squaresoft
}

local PLAYLIST9 = {
    {file = "PLAYLIST9_1.ogg", duration = 294} -- 03:45 Wave Goodbye by Chris Cornell
}

local PLAYLIST10 = {
    {file = "PLAYLIST10_1.ogg", duration = 180} -- 06:05 Fire Field - F-Zero by Nintendo
}

local PLAYLIST11 = {
    {file = "PLAYLIST11_1.ogg", duration = 45}, -- 00:45 Boss 3 - Gradius III by Konami
    {file = "PLAYLIST11_2.ogg", duration = 44}, -- 00:44 Boss 4 - Gradius III by Konami
    {file = "PLAYLIST11_3.ogg", duration = 50}, -- 00:50 Boss 5 - Gradius III by Konami
    {file = "PLAYLIST11_4.ogg", duration = 27}, -- 00:27 Last Struggle - Gradius III by Konami
    {file = "PLAYLIST11_5.ogg", duration = 88}, -- 01:28 Dead End Cell - Gradius III by Konami
	{file = "PLAYLIST11_6.ogg", duration = 33} -- 00:33 Sharp Shot - Gradius III by Konami
}

local PLAYLIST12 = {
    {file = "PLAYLIST12_1.ogg", duration = 365} -- 06:05 The Extreme - Final Fantasy VIII by Squaresoft
}

local PLAYLIST13 = {
    {file = "PLAYLIST13_1.ogg", duration = 177} -- 02:57 Amphibians' Land - E. V. O. Search for Eden by Enix
}

local PLAYLIST14 = {
    {file = "PLAYLIST14_1.ogg", duration = 165} -- 06:05 Birthplace of All Life - E. V. O. Search for Eden by Enix
}

local PLAYLIST15 = {
    {file = "PLAYLIST15_1.ogg", duration = 206} -- 03:26 Balamb Garden - Final Fantasy VIII by Squaresoft
}

local PLAYLIST16 = {
    {file = "PLAYLIST16_1.ogg", duration = 84} -- 01:24 Fear - Final Fantasy VIII by Squaresoft
}

SOUNDS = {
    {fromPos = {x=1, y=1, z=1}, toPos = {x=2449, y=4501, z=15}, area = "PLAYLIST1"},
    {fromPos = {x=2450, y=1, z=1}, toPos = {x=4147, y=4123, z=15}, area = "PLAYLIST2"},
    {fromPos = {x=1223, y=1335, z=7}, toPos = {x=1244, y=1356, z=7}, area = "PLAYLIST3"},
    {fromPos = {x=1610, y=1433, z=6}, toPos = {x=1623, y=1443, z=7}, area = "PLAYLIST4"},
    {fromPos = {x=1526, y=1327, z=0}, toPos = {x=1677, y=1469, z=8}, area = "PLAYLIST5"},
    {fromPos = {x=102, y=163, z=0}, toPos = {x=240, y=417, z=15}, area = "PLAYLIST6"},
	{fromPos = {x=1110, y=878, z=6}, toPos = {x=1192, y=952, z=6}, area = "PLAYLIST7"},
    {fromPos = {x=1116, y=879, z=7}, toPos = {x=1217, y=992, z=7}, area = "PLAYLIST7"},
    {fromPos = {x=1138, y=899, z=0}, toPos = {x=1216, y=966, z=13}, area = "PLAYLIST7"},
	{fromPos = {x=1133, y=888, z=12}, toPos = {x=1216, y=966, z=12}, area = "PLAYLIST7"},
	{fromPos = {x=1143, y=904, z=13}, toPos = {x=1159, y=921, z=13}, area = "PLAYLIST7"},
	{fromPos = {x=1143, y=949, z=5}, toPos = {x=1183, y=1047, z=5}, area = "PLAYLIST7"},
	{fromPos = {x=1139, y=822, z=8}, toPos = {x=1251, y=904, z=8}, area = "PLAYLIST7"},	
	{fromPos = {x=892, y=902, z=8}, toPos = {x=1251, y=957, z=8}, area = "PLAYLIST7"},	
    {fromPos = {x=1703, y=1133, z=0}, toPos = {x=1882, y=1259, z=9}, area = "PLAYLIST8"},	
    {fromPos = {x=3242, y=1258, z=6}, toPos = {x=3250, y=1266, z=7}, area = "PLAYLIST9"},
    {fromPos = {x=2972, y=1866, z=7}, toPos = {x=3562, y=2228, z=7}, area = "PLAYLIST10"},
    {fromPos = {x=3220, y=1155, z=14}, toPos = {x=3331, y=1259, z=15}, area = "PLAYLIST11"},
	{fromPos = {x=1378, y=1422, z=11}, toPos = {x=1400, y=1444, z=11}, area = "PLAYLIST11"},
	{fromPos = {x=791, y=1100, z=15}, toPos = {x=821, y=1137, z=15}, area = "PLAYLIST11"},
	{fromPos = {x=1525, y=1409, z=14}, toPos = {x=1588, y=1465, z=14}, area = "PLAYLIST11"},
	{fromPos = {x=854, y=819, z=14}, toPos = {x=883, y=845, z=14}, area = "PLAYLIST11"},
	{fromPos = {x=912, y=1278, z=15}, toPos = {x=947, y=1304, z=15}, area = "PLAYLIST11"},
	{fromPos = {x=852, y=1053, z=14}, toPos = {x=871, y=1072, z=14}, area = "PLAYLIST11"},
	{fromPos = {x=1649, y=1098, z=15}, toPos = {x=1687, y=1125, z=15}, area = "PLAYLIST11"},
	{fromPos = {x=1072, y=976, z=15}, toPos = {x=1289, y=993, z=15}, area = "PLAYLIST11"},
    {fromPos = {x=3272, y=79, z=0}, toPos = {x=3360, y=165, z=0}, area = "PLAYLIST12"},
    {fromPos = {x=248, y=1223, z=0}, toPos = {x=519, y=1601, z=15}, area = "PLAYLIST13"},
    {fromPos = {x=1246, y=1056, z=14}, toPos = {x=1342, y=1175, z=15}, area = "PLAYLIST14"},
	{fromPos = {x=1340, y=1095, z=14}, toPos = {x=1568, y=1198, z=15}, area = "PLAYLIST14"},
	{fromPos = {x=1005, y=1100, z=15}, toPos = {x=1245, y=1225, z=15}, area = "PLAYLIST14"},
	{fromPos = {x=1017, y=1229, z=15}, toPos = {x=1240, y=1608, z=15}, area = "PLAYLIST14"},
	{fromPos = {x=1037, y=1239, z=14}, toPos = {x=1148, y=1288, z=14}, area = "PLAYLIST14"},
	{fromPos = {x=1148, y=1197, z=14}, toPos = {x=1171, y=1120, z=14}, area = "PLAYLIST14"},
	{fromPos = {x=1145, y=1325, z=14}, toPos = {x=1163, y=1411, z=14}, area = "PLAYLIST14"},
	{fromPos = {x=1135, y=1365, z=12}, toPos = {x=1235, y=1440, z=12}, area = "PLAYLIST14"},
	{fromPos = {x=941, y=1210, z=8}, toPos = {x=1016, y=1304, z=10}, area = "PLAYLIST14"},
	{fromPos = {x=1497, y=1373, z=11}, toPos = {x=1630, y=1490, z=14}, area = "PLAYLIST14"},
	{fromPos = {x=998, y=836, z=8}, toPos = {x=1038, y=864, z=8}, area = "PLAYLIST14"},
	{fromPos = {x=994, y=820, z=9}, toPos = {x=1029, y=922, z=9}, area = "PLAYLIST14"},
	{fromPos = {x=919, y=878, z=9}, toPos = {x=990, y=923, z=9}, area = "PLAYLIST14"},
	{fromPos = {x=966, y=1018, z=8}, toPos = {x=1134, y=1102, z=8}, area = "PLAYLIST14"},
	{fromPos = {x=949, y=1080, z=8}, toPos = {x=1033, y=1114, z=8}, area = "PLAYLIST14"},
	{fromPos = {x=979, y=1115, z=8}, toPos = {x=992, y=1139, z=8}, area = "PLAYLIST14"},
	{fromPos = {x=1047, y=1103, z=8}, toPos = {x=1134, y=1115, z=8}, area = "PLAYLIST14"},
	{fromPos = {x=1047, y=1103, z=8}, toPos = {x=1134, y=1115, z=8}, area = "PLAYLIST14"},
	{fromPos = {x=1062, y=1116, z=8}, toPos = {x=1134, y=1132, z=8}, area = "PLAYLIST14"},
	{fromPos = {x=1035, y=1111, z=8}, toPos = {x=1143, y=1131, z=8}, area = "PLAYLIST14"},
	{fromPos = {x=1058, y=1122, z=8}, toPos = {x=1061, y=1126, z=8}, area = "PLAYLIST14"},
	{fromPos = {x=971, y=1031, z=9}, toPos = {x=1059, y=1130, z=9}, area = "PLAYLIST14"},
	{fromPos = {x=1193, y=1213, z=5}, toPos = {x=1206, y=1224, z=7}, area = "PLAYLIST15"},
	{fromPos = {x=1190, y=1190, z=8}, toPos = {x=1218, y=1218, z=8}, area = "PLAYLIST15"},
	{fromPos = {x=1203, y=1219, z=8}, toPos = {x=1217, y=1221, z=8}, area = "PLAYLIST15"},	
	{fromPos = {x=1187, y=1177, z=9}, toPos = {x=1208, y=1195, z=9}, area = "PLAYLIST15"},	
	{fromPos = {x=1177, y=1162, z=10}, toPos = {x=1194, y=1179, z=10}, area = "PLAYLIST15"},
	{fromPos = {x=1183, y=1176, z=11}, toPos = {x=1189, y=1179, z=11}, area = "PLAYLIST15"},	
	{fromPos = {x=1162, y=1181, z=9}, toPos = {x=1186, y=1195, z=9}, area = "PLAYLIST16"},
	{fromPos = {x=1176, y=1186, z=10}, toPos = {x=1195, y=1194, z=10}, area = "PLAYLIST16"},
	{fromPos = {x=1189, y=1184, z=11}, toPos = {x=1315, y=1203, z=11}, area = "PLAYLIST16"},
	{fromPos = {x=1207, y=1172, z=11}, toPos = {x=1233, y=1183, z=11}, area = "PLAYLIST16"},
	{fromPos = {x=1203, y=1204, z=11}, toPos = {x=1240, y=1210, z=11}, area = "PLAYLIST16"},
	{fromPos = {x=1248, y=1204, z=11}, toPos = {x=1300, y=1229, z=11}, area = "PLAYLIST16"},
	{fromPos = {x=1294, y=1159, z=11}, toPos = {x=1314, y=1183, z=11}, area = "PLAYLIST16"}
}

math.randomseed(os.time())

local rcSoundChannel
local toggleSoundEvent
local playingSound
local nextSongEvent

function init()
    connect(g_game, { 
        onGameStart = onGameStart,
        onGameEnd = onGameEnd 
    })
    
    rcSoundChannel = g_sounds.getChannel(SOUNDS_CONFIG.soundChannel)
    
    if g_game.isOnline() then
        onGameStart()
    end
end

function terminate()
    disconnect(g_game, { 
        onGameStart = onGameStart,
        onGameEnd = onGameEnd 
    })
    onGameEnd()
end

function onGameStart()
    stopSound()
    toggleSoundEvent = addEvent(toggleSound, SOUNDS_CONFIG.checkInterval)
end

function onGameEnd()
    stopSound()
    removeEvent(toggleSoundEvent)
    removeEvent(nextSongEvent)
end

function isInPos(pos, fromPos, toPos)
    return pos.x >= fromPos.x and
           pos.y >= fromPos.y and
           pos.z >= fromPos.z and
           pos.x <= toPos.x and
           pos.y <= toPos.y and
           pos.z <= toPos.z
end

function getAreaVolume(fromPos, toPos)
    return (toPos.x - fromPos.x + 1) * (toPos.y - fromPos.y + 1) * (toPos.z - fromPos.z + 1)
end

function toggleSound()
    local player = g_game.getLocalPlayer()
    if not player then return end

    local pos = player:getPosition()
    local currentArea = nil

    table.sort(SOUNDS, function(a, b)
        return getAreaVolume(a.fromPos, a.toPos) < getAreaVolume(b.fromPos, b.toPos)
    end)

    for i = 1, #SOUNDS do
        if isInPos(pos, SOUNDS[i].fromPos, SOUNDS[i].toPos) then
            currentArea = SOUNDS[i].area
            break
        end
    end

    if currentArea and (not playingSound or playingSound.area ~= currentArea) then
        playRandomSound(currentArea)
    elseif not currentArea and playingSound then
        stopSound()
    end

    toggleSoundEvent = scheduleEvent(toggleSound, SOUNDS_CONFIG.checkInterval)
end


function playRandomSound(area)
    local songList
    if area == "PLAYLIST1" then
        songList = PLAYLIST1
    elseif area == "PLAYLIST2" then
        songList = PLAYLIST2
    elseif area == "PLAYLIST3" then
        songList = PLAYLIST3
    elseif area == "PLAYLIST4" then
        songList = PLAYLIST4
    elseif area == "PLAYLIST5" then
        songList = PLAYLIST5	
    elseif area == "PLAYLIST6" then		
        songList = PLAYLIST6
    elseif area == "PLAYLIST7" then		
        songList = PLAYLIST7
    elseif area == "PLAYLIST8" then
        songList = PLAYLIST8
    elseif area == "PLAYLIST9" then
        songList = PLAYLIST9
    elseif area == "PLAYLIST10" then
        songList = PLAYLIST10
    elseif area == "PLAYLIST11" then
        songList = PLAYLIST11
    elseif area == "PLAYLIST12" then
        songList = PLAYLIST12
    elseif area == "PLAYLIST13" then
        songList = PLAYLIST13
    elseif area == "PLAYLIST14" then
        songList = PLAYLIST14
    elseif area == "PLAYLIST15" then
        songList = PLAYLIST15
    elseif area == "PLAYLIST16" then
        songList = PLAYLIST16
    else
        return
    end

    local song = songList[math.random(#songList)]
    local fullPath = SOUNDS_CONFIG.folder .. song.file

    stopSound()
    rcSoundChannel:enqueue(fullPath, 0)
    playingSound = {sound = fullPath, area = area, duration = song.duration}

    nextSongEvent = scheduleEvent(function()
        if playingSound and playingSound.area == area then
            playRandomSound(area)
        end
    end, song.duration * 1000)
end

function stopSound()
    rcSoundChannel:stop()
    playingSound = nil
    removeEvent(nextSongEvent)
end